// SPDX-License-Identifier: GPL-2.0
/*
 * u_uac1.h - Utility definitions for UAC1 function
 *
 * Copyright (C) 2016 Ruslan Bilovol <ruslan.bilovol@gmail.com>
 */

#ifndef __U_UAC1_H
#define __U_UAC1_H

#include <linux/usb/composite.h>

#define UAC1_OUT_EP_MAX_PACKET_SIZE	200
#define UAC1_DEF_CCHMASK	0x3
#define UAC1_DEF_CSRATE		48000
#define UAC1_DEF_CSSIZE		2
#define UAC1_DEF_PCHMASK	0x3
#define UAC1_DEF_PSRATE		48000
#define UAC1_DEF_PSSIZE		2
#define UAC1_DEF_REQ_NUM	8

typedef enum audio_mode {
	DISABLE_UAC,
	ENABLE_SPEAKER,
	ENABLE_MICROPHONE,
	ENABLE_MIC_AND_SPK,
	UNKNOWN_COMMAND,
} audio_mode_e;

struct f_uac1_opts {
	struct usb_function_instance	func_inst;
	int				c_mpsize;
	int				c_chmask;
	int				c_srate;
	int				c_ssize;
	int				p_mpsize;
	int				p_chmask;
	int				p_srate;
	int				p_ssize;
	int				req_number;
	unsigned			bound:1;

	struct mutex			lock;
	int				refcnt;
	audio_mode_e			audio_play_mode;
};

#endif /* __U_UAC1_H */
